'
' Egzemplarze tej klasy reprezentuj token nieterminalny
' OrCombination.
'
Public Class OrCombination
    Implements ICombination
    Private leftChild, rightChild As ICombination

    ' Konstruktor
    ' left - Lewy lewy potomek tego obiektu.
    ' right - Pprawy potomek tego obiektu.
    Public Sub New(ByVal left As ICombination, ByVal right As ICombination)
        leftChild = left
        rightChild = right
    End Sub

    '
    ' Metoda Contains zwraca tablic pozycji tych wyrazw w acuchu
    ' wejciowym, ktre speniaj wymagania stawiane przez oba obiekty
    ' potomne tego egzemplarza klasy OrCombination. Jeli jednak wszystkie
    ' wyrazy w danym acuchu speniaj wymagania obu obiektw potomnych,
    ' funkcja Contains zwraca tablic pust. W przeciwnym razie metoda
    ' zwraca warto Nothing.
    '
    ' s - acuchacuch, ktry zostanie przeszukany przez t metod pod ktem
    '     zawierania wymaganego sowa.
    Public Function Contains(ByVal s As String) As Integer() _
     Implements ICombination.Contains
        Dim leftResult As Integer() = leftChild.Contains(s)
        Dim rightResult As Integer() = rightChild.Contains(s)
        If leftResult Is Nothing Then
            Return rightResult
        End If
        If rightResult Is Nothing Then
            Return leftResult
        End If
        If leftResult.Length = 0 Then
            Return leftResult
        End If
        If rightResult.Length = 0 Then
            Return rightResult
        End If ' Tworzy tablic poczonych wynikw.
        Dim myResult() As Integer
        myResult = New Integer(leftResult.Length + rightResult.Length) {}
        System.Array.Copy(leftResult, 0, myResult, 0, leftResult.Length)
        System.Array.Copy(rightResult, 0, myResult, leftResult.Length, rightResult.Length)
        Return myResult
    End Function
End Class 'OrCombination
